/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.oldVersion;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.config.Webhook;
import org.pokesplash.gts.oldVersion.ItemPricesOld;
import org.pokesplash.gts.util.Utils;

public class ConfigOld {
    private String version = "2.2";
    private boolean broadcastListings = true;
    private boolean enablePermissionNodes = true;
    private int maxListingsPerPlayer = 8;
    private int listingDuration = 72;
    private Webhook discord;
    private boolean showBreedable;
    private double minPrice1IV = 10000.0;
    private double minPrice2IV = 20000.0;
    private double minPrice3IV = 30000.0;
    private double minPrice4IV = 40000.0;
    private double minPrice5IV = 50000.0;
    private double minPrice6IV = 60000.0;
    private double minPriceHA = 50000.0;
    private double minPriceLegendary = 50000.0;
    private double minPriceUltrabeast = 30000.0;
    private double maximumPrice = 1000000.0;
    private List<ItemPricesOld> customItemPrices = new ArrayList<ItemPricesOld>();
    private List<String> bannedItems;
    private List<String> bannedPokemon;

    public ConfigOld() {
        this.customItemPrices.add(new ItemPricesOld());
        this.bannedItems = new ArrayList<String>();
        this.bannedItems.add("cobblemon:lucky_egg");
        this.bannedPokemon = new ArrayList<String>();
        this.bannedPokemon.add("magikarp");
        this.discord = new Webhook();
        this.showBreedable = false;
    }

    public void init() {
        CompletableFuture<Boolean> futureRead = Utils.readFileAsync("/config/gts/", "config.json", el -> {
            Gson gson = Utils.newGson();
            ConfigOld cfg = (ConfigOld)gson.fromJson(el, ConfigOld.class);
            this.broadcastListings = cfg.isBroadcastListings();
            this.maxListingsPerPlayer = cfg.getMaxListingsPerPlayer();
            this.listingDuration = cfg.getListingDuration();
            this.minPrice1IV = cfg.getMinPrice1IV();
            this.minPrice2IV = cfg.getMinPrice2IV();
            this.minPrice3IV = cfg.getMinPrice3IV();
            this.minPrice4IV = cfg.getMinPrice4IV();
            this.minPrice5IV = cfg.getMinPrice5IV();
            this.minPrice6IV = cfg.getMinPrice6IV();
            this.minPriceHA = cfg.getMinPriceHA();
            this.minPriceLegendary = cfg.getMinPriceLegendary();
            this.minPriceUltrabeast = cfg.getMinPriceUltrabeast();
            this.maximumPrice = cfg.getMaximumPrice();
            this.customItemPrices = cfg.getCustomItemPrices();
            this.bannedItems = cfg.getBannedItems();
            this.bannedPokemon = cfg.getBannedPokemon();
            this.enablePermissionNodes = cfg.isEnablePermissionNodes();
            this.discord = cfg.getDiscord() == null ? new Webhook() : cfg.getDiscord();
            this.showBreedable = cfg.isShowBreedable();
            if (!cfg.getVersion().equals("2.2")) {
                Gts.LOGGER.info("GTS Config outdated, updating config...");
                this.write();
                Gts.LOGGER.info("Config successfully updated for GTS!");
            }
        });
        if (!futureRead.join().booleanValue()) {
            Gts.LOGGER.info("No config.json file found for GTS. Attempting to generate one.");
            CompletableFuture<Boolean> futureWrite = this.write();
            if (!futureWrite.join().booleanValue()) {
                Gts.LOGGER.fatal("Could not write config for GTS.");
            }
            return;
        }
        Gts.LOGGER.info("GTS config file read successfully.");
    }

    public CompletableFuture<Boolean> write() {
        Gson gson = Utils.newGson();
        String data = gson.toJson((Object)this);
        return Utils.writeFileAsync("/config/gts/", "config.json", data);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isBroadcastListings() {
        return this.broadcastListings;
    }

    public int getMaxListingsPerPlayer() {
        return this.maxListingsPerPlayer;
    }

    public int getListingDuration() {
        return this.listingDuration;
    }

    public double getMinPrice1IV() {
        return this.minPrice1IV;
    }

    public double getMinPrice2IV() {
        return this.minPrice2IV;
    }

    public double getMinPrice3IV() {
        return this.minPrice3IV;
    }

    public double getMinPrice4IV() {
        return this.minPrice4IV;
    }

    public double getMinPrice5IV() {
        return this.minPrice5IV;
    }

    public double getMinPrice6IV() {
        return this.minPrice6IV;
    }

    public double getMinPriceHA() {
        return this.minPriceHA;
    }

    public double getMaximumPrice() {
        return this.maximumPrice;
    }

    public List<ItemPricesOld> getCustomItemPrices() {
        return this.customItemPrices;
    }

    public List<String> getBannedItems() {
        return this.bannedItems;
    }

    public boolean isEnablePermissionNodes() {
        return this.enablePermissionNodes;
    }

    public HashSet<Double> getAllPokemonPrices() {
        HashSet<Double> prices = new HashSet<Double>();
        prices.add(this.minPrice1IV);
        prices.add(this.minPrice2IV);
        prices.add(this.minPrice3IV);
        prices.add(this.minPrice4IV);
        prices.add(this.minPrice5IV);
        prices.add(this.minPrice6IV);
        prices.add(this.minPriceHA);
        return prices;
    }

    public List<String> getBannedPokemon() {
        return this.bannedPokemon;
    }

    public double getMinPriceLegendary() {
        return this.minPriceLegendary;
    }

    public double getMinPriceUltrabeast() {
        return this.minPriceUltrabeast;
    }

    public Webhook getDiscord() {
        return this.discord;
    }

    public boolean isShowBreedable() {
        return this.showBreedable;
    }
}

